<?php
/*--------------------------------------------------------------
   Provider.php 2021-08-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Schema;

use Swaggest\JsonSchema\RemoteRefProvider;

class Provider implements RemoteRefProvider
{
    private const SCHEMES = [
        "https://gambio.com/schema/definition/Data/Table/Column/Boolean.json"    => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Boolean.json",
        "https://gambio.com/schema/definition/Data/Table/Column/Date.json"       => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Date.json",
        "https://gambio.com/schema/definition/Data/Table/Column/Decimal.json"    => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Decimal.json",
        "https://gambio.com/schema/definition/Data/Table/Column/Integer.json"    => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Integer.json",
        "https://gambio.com/schema/definition/Data/Table/Column/Percentage.json" => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Percentage.json",
        "https://gambio.com/schema/definition/Data/Table/Column/Text.json"       => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column/Text.json",
        "https://gambio.com/schema/definition/Data/Table/Row/Field/Boolean.json" => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Row/Field/Boolean.json",
        "https://gambio.com/schema/definition/Data/Table/Row/Field/Number.json"  => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Row/Field/Number.json",
        "https://gambio.com/schema/definition/Data/Table/Row/Field/String.json"  => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Row/Field/String.json",
        "https://gambio.com/schema/definition/Data/Table/Row/Field.json"         => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Row/Field.json",
        "https://gambio.com/schema/definition/Data/Table/Column.json"            => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Column.json",
        "https://gambio.com/schema/definition/Data/Table/Row.json"               => __DIR__
                                                                                    . "/Json/Definition/Data/Table/Row.json",
        "https://gambio.com/schema/definition/Data/Map.json"                     => __DIR__
                                                                                    . "/Json/Definition/Data/Map.json",
        "https://gambio.com/schema/definition/Data/Serial.json"                  => __DIR__
                                                                                    . "/Json/Definition/Data/Serial.json",
        "https://gambio.com/schema/definition/Data/Table.json"                   => __DIR__
                                                                                    . "/Json/Definition/Data/Table.json",
        "https://gambio.com/schema/definition/Data/Text.json"                    => __DIR__
                                                                                    . "/Json/Definition/Data/Text.json",
        "https://gambio.com/schema/definition/Data/Number.json"                  => __DIR__
                                                                                    . "/Json/Definition/Data/Number.json",
        "https://gambio.com/schema/definition/Option/Checkbox.json"              => __DIR__
                                                                                    . "/Json/Definition/Option/Checkbox.json",
        "https://gambio.com/schema/definition/Option/Dropdown.json"              => __DIR__
                                                                                    . "/Json/Definition/Option/Dropdown.json",
        "https://gambio.com/schema/definition/Option/Number.json"                => __DIR__
                                                                                    . "/Json/Definition/Option/Number.json",
        "https://gambio.com/schema/definition/Option/Text.json"                  => __DIR__
                                                                                    . "/Json/Definition/Option/Text.json",
        "https://gambio.com/schema/definition/Author.json"                       => __DIR__
                                                                                    . "/Json/Definition/Author.json",
        "https://gambio.com/schema/definition/Data.json"                         => __DIR__
                                                                                    . "/Json/Definition/Data.json",
        "https://gambio.com/schema/definition/Height.json"                       => __DIR__
                                                                                    . "/Json/Definition/Height.json",
        "https://gambio.com/schema/definition/HorizontalPosition.json"           => __DIR__
                                                                                    . "/Json/Definition/HorizontalPosition.json",
        "https://gambio.com/schema/definition/Icon.json"                         => __DIR__
                                                                                    . "/Json/Definition/Icon.json",
        "https://gambio.com/schema/definition/Id.json"                           => __DIR__
                                                                                    . "/Json/Definition/Id.json",
        "https://gambio.com/schema/definition/Label.json"                        => __DIR__
                                                                                    . "/Json/Definition/Label.json",
        "https://gambio.com/schema/definition/Option.json"                       => __DIR__
                                                                                    . "/Json/Definition/Option.json",
        "https://gambio.com/schema/definition/Options.json"                      => __DIR__
                                                                                    . "/Json/Definition/Options.json",
        "https://gambio.com/schema/definition/Title.json"                        => __DIR__
                                                                                    . "/Json/Definition/Title.json",
        "https://gambio.com/schema/definition/Type.json"                         => __DIR__
                                                                                    . "/Json/Definition/Type.json",
        "https://gambio.com/schema/definition/UpdateSet.json"                    => __DIR__
                                                                                    . "/Json/Definition/UpdateSet.json",
        "https://gambio.com/schema/definition/Version.json"                      => __DIR__
                                                                                    . "/Json/Definition/Version.json",
        "https://gambio.com/schema/definition/VerticalPosition.json"             => __DIR__
                                                                                    . "/Json/Definition/VerticalPosition.json",
        "https://gambio.com/schema/definition/Visualization.json"                => __DIR__
                                                                                    . "/Json/Definition/Visualization.json",
        "https://gambio.com/schema/definition/Width.json"                        => __DIR__
                                                                                    . "/Json/Definition/Width.json",
    ];
    
    
    /**
     * @inheritDoc
     */
    public function getSchemaData($url)
    {
        return array_key_exists($url, self::SCHEMES) ? json_decode(file_get_contents(self::SCHEMES[$url])) : false;
    }
}